/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.circuit.interfaces.wire;

import net.minecraft.util.StringRepresentable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum WireConnectionState {
    DISCONNECTED(0, Visual.DISCONNECTED),
    FORCE_DISCONNECTED(1, Visual.DISCONNECTED),
    WIRE(2, Visual.ANODE),
    INPUT(4, Visual.CATHODE){

        @Override
        public WireConnectionState getOpposite() {
            return OUTPUT;
        }
    }
    ,
    OUTPUT(5, Visual.ANODE){

        @Override
        public WireConnectionState getOpposite() {
            return INPUT;
        }
    };

    private static final WireConnectionState[] VALUES;
    private static final WireConnectionState[] SERIAL_VALUES;
    private final int id;
    private final Visual visualState;

    private WireConnectionState(int id, Visual visualState) {
        this.id = id;
        this.visualState = visualState;
    }

    public Visual getVisualState() {
        return this.visualState;
    }

    public int serialize() {
        return this.id;
    }

    public static WireConnectionState deserialize(int value) {
        return SERIAL_VALUES[value];
    }

    public WireConnectionState getOpposite() {
        return this;
    }

    public boolean isDisconnected() {
        return this == DISCONNECTED || this == FORCE_DISCONNECTED;
    }

    static {
        VALUES = WireConnectionState.values();
        SERIAL_VALUES = new WireConnectionState[]{DISCONNECTED, FORCE_DISCONNECTED, WIRE, WIRE, INPUT, OUTPUT};
    }

    public static enum Visual implements StringRepresentable
    {
        DISCONNECTED("disconnected"),
        ANODE("anode"),
        CATHODE("cathode");

        private final String name;

        private Visual(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

